<?xml version="1.0" encoding="utf-8"?><!DOCTYPE xsl:stylesheet  [
	<!ENTITY nbsp   "&#160;">
	<!ENTITY copy   "&#169;">
	<!ENTITY reg    "&#174;">
	<!ENTITY trade  "&#8482;">
	<!ENTITY mdash  "&#8212;">
	<!ENTITY ldquo  "&#8220;">
	<!ENTITY rdquo  "&#8221;"> 
	<!ENTITY pound  "&#163;">
	<!ENTITY yen    "&#165;">
	<!ENTITY euro   "&#8364;">
]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" encoding="utf-8" doctype-public="-//MOZILLA//DTD XUL V1.0//EN"/>
<xsl:template match="/MediaCoderPrefs">

<!--?xml-stylesheet href="chrome://global/skin/" type="text/css"?-->

<window id="prefs_tree"
        xmlns:html="http://www.w3.org/1999/xhtml"
        xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
        xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"
		flex="1"
        >
<tree rows="6" flex="1" onselect="onTreeSelected(this)">
  <treecols>
      <treecol id="param" label="Parameter" primary="true" flex="5"/>
	  <treecol id="type" label="Type" flex="1"/>
      <treecol id="value" label="Value" flex="5"/>
  </treecols>

  <treechildren>
	<xsl:for-each select="node">
	  <treeitem container="true">
	  <xsl:if test="last()=1">
	  <xsl:attribute name="open">true</xsl:attribute>
	  </xsl:if>
	  <xsl:attribute name="uri"><xsl:value-of select="@key"/></xsl:attribute>
	  <treerow>
		<treecell>
		  <xsl:attribute name="label"><xsl:value-of select="@text"/></xsl:attribute>
		</treecell>
	  </treerow>
      <treechildren>
		<xsl:for-each select="node">
		  <treeitem container="true">
		  <xsl:if test="last()=1">
		  <xsl:attribute name="open">true</xsl:attribute>
		  </xsl:if>
		  <xsl:attribute name="uri"><xsl:value-of select="@key"/></xsl:attribute>
		  <treerow>
			<treecell>
			  <xsl:attribute name="label"><xsl:value-of select="@text"/></xsl:attribute>
			</treecell>
		  </treerow>
		  <treechildren>
			<xsl:for-each select="node">
			  <treeitem>
			  <xsl:attribute name="uri"><xsl:value-of select="@key"/></xsl:attribute>
			  <treerow>
				<treecell>
				  <xsl:attribute name="label"><xsl:value-of select="@text"/></xsl:attribute>
				</treecell>
				<treecell>
				  <xsl:attribute name="label">
				    <xsl:choose>
					<xsl:when test="@type='bool'">Boolean</xsl:when>
					<xsl:when test="@type='int'">Integer</xsl:when>
					<xsl:when test="@type='float'">Float</xsl:when>
					<xsl:when test="@type='enum'">Enum</xsl:when>
					<xsl:when test="@type='string'">String</xsl:when>
					<xsl:when test="@type='file'">File Path</xsl:when>
					<xsl:when test="@type='dir'">Dir Path</xsl:when>
					<xsl:otherwise><xsl:value-of select="@type"/></xsl:otherwise>
					</xsl:choose>
				  </xsl:attribute>
				</treecell>
				<treecell>
				  <xsl:attribute name="label"><xsl:value-of select="value"/></xsl:attribute>
				</treecell>
			  </treerow>
			  </treeitem>
			 </xsl:for-each>
		  </treechildren>
		  </treeitem>
		 </xsl:for-each>
	  </treechildren>
	  </treeitem>
	</xsl:for-each>
  </treechildren>
</tree>
</window>
</xsl:template>
</xsl:stylesheet>